<style type="text/css">

    @media(max-width: 767px) {
        .erp_pro_addons_wrapper[class] {
            padding: 42px 0;
            width: 100%;
            margin: 0 auto;
        }

        .erp_pro_addons_wrapper .banner_section[class] {
            display: inherit;
            align-items: center;
            justify-content: center;
            height: 100%;
            text-align: center;
            padding: 0 5px 34px;

        }

        .erp_pro_addons_wrapper .banner_section[class] h1 {
            font-size: 24.5px;
        }

        .erp_pro_addons_wrapper .banner_section .image-item[class] {
            margin-right: 0;
        }

        .button-wrap[class] img {
            width: auto;
        }

        .banner_section img {
            width: 100%;
        }

        .erp_pro_addons_wrapper .banner_section .button-wrap .btn[class] {
            padding: 12px 18px;
        }

        .erp_pro_addons_wrapper .why__erppro_wrap[class] {
            display: block;
            flex-flow: inherit;
            justify-content: inherit;
        }
        .erp_pro_addons_wrapper .box_item[class], .erp_pro_addons_wrapper .why__erppro_wrap .box_item[class] {
            flex-basis: 100%;
            max-width: 100%;
            margin-bottom: 14px;
        }

        .perful_extension_wrap .perful_extension[class] {
            display: block;
            justify-content: inherit;
            flex-flow: inherit;
            padding: 0 4px;
        }

        .erp_pro_addons_wrapper .single_extension .desc[class] {
            padding-right: 0;
        }

        .erp_pro_addons_wrapper .single_extension[class] {
            align-items: inherit;
            flex-basis: 100%;
            max-width: 100%;
            padding: 16px 12px;
            margin-bottom: 23px;
            flex-flow: row wrap;
            justify-content: flex-start;
        }

        .erp_pro_addons_wrapper .single_extension .image[class] {
            margin-right: 10px;
            padding-left: 0;
            width: 30%;
            height: 30%;
        }

        .erp_pro_addons_wrapper .single_extension .image[class] img {
            width: 100%;
            height: auto;
        }
        .erp_pro_addons_wrapper .single_extension .desc[class] {
            flex-basis: 65%;
            max-width: 65%;
        }

        .erp_pro_addons_wrapper .single_extension .desc[class] h4 {
            margin: 0;
            margin-bottom: 0;
            text-align: left;
        }

        .erp_pro_addons_wrapper .single_extension .desc[class] p {
            margin: 8px 0;
        }

        .erp_pro_addons_wrapper .section_head[class] h2 {
            font-size: 26px;
            line-height: 35px;
            display: inherit;
        }

        .premium_extension_section .premium_extension[class] {
            display: block;
            justify-content: inherit;
            flex-flow: inherit;
            padding: 0;

        }

        .erp_pro_addons_wrapper .say_hello_section[class] h3 {
            font-size: 20px;
            margin-bottom: 0px;
        }

        .erp_pro_addons_wrapper .say_hello_section p {
            font-size: 13.96px;
            padding: 23px 12px 0;
        }

        br {
            display:none;
        }

        .erp_pro_addons_wrapper .filter_tab_item .button_group[class] li a {
            display: block;
        }

        .erp_pro_addons_wrapper .filter_tab_item .button_group[class] li {
            display: block;
        }

        .erp_pro_addons_wrapper .box_item[class] p {
            padding: 0 10px;
        }


    }

    @media(min-width: 768px) and (max-width: 1024px) {
        .erp_pro_addons_wrapper[class] {
            padding: 42px 0;
            width: 100%;
            margin: 0 auto;
        }

        .erp_pro_addons_wrapper .why__erppro_wrap .box_item[class] {
            flex-basis: 48%;
            max-width: 48%;
        }

        .erp_pro_addons_wrapper .single_extension[class] {
            flex-basis: 48%;
            max-width: 48%;
        }

        .perful_extension_wrap .perful_extension[class] {
            padding: 0 20px;
        }

        .erp_pro_addons_wrapper .box_item[class] {
            flex-basis: 48%;
            max-width: 48%;
            margin-bottom: 20px;
        }


    }
    /* end responsive style */


    .erp_pro_addons_wrapper {
        padding: 42px 0;
        font-family: 'Lato', sans-serif;
        width: 884px;
        margin: 0 auto;

    }

    .erp_pro_addons_wrapper .exclusive_feature_wrap {
        display: flex;
        justify-content: space-between;
        flex-flow: row wrap;
    }

    /*=======================
    Box Stle
    =======================*/
    .erp_pro_addons_wrapper .box_item {
        background: #FFFFFF;
        border: 1px solid #E2E2E2;
        border-radius: 5px;
        flex-basis: 283px;
        max-width: 283px;
        text-align: center;
        padding: 40px 0;
        margin-bottom: 15px;
    }

    .erp_pro_addons_wrapper .box_item .image{
        height: 134px;
    }

    .erp_pro_addons_wrapper .box_item h3 {
        font-size: 20px;
        color: #2C3847;
        letter-spacing: 0.18px;
        text-align: center;
        line-height: 28px;
        font-weight: 700;
        margin-bottom: 17px;
        padding: 0 20px;
    }
    .erp_pro_addons_wrapper .box_item p {
        font-size: 13px;
        color: #334E68;
        letter-spacing: 0.12px;
        text-align: center;
        line-height: 22px;
        font-weight: 400;
        margin-bottom: 0;
        padding: 0 20px;
    }
    /*=======================
    End Box Stle
    =======================*/


    /*=======================
    Extension Stle
    =======================*/
    .erp_pro_addons_wrapper .single_extension{
        background: #FFFFFF;
        border: 0 solid rgba(151,151,151,0.22);
        box-shadow: 0 4px 16px 0 rgba(0,38,85,0.05);
        border-radius: 8px;
        display: flex;
        flex-basis: 376px;
        max-width: 376px;
        padding: 24px 0;
        margin-bottom: 23px;
    }

    .erp_pro_addons_wrapper .single_extension .image{
        margin-right: 20px;
        padding-left: 24px;

    }

    .erp_pro_addons_wrapper .single_extension .image img {
        width: 98px;
        height: 65px;
    }

    .erp_pro_addons_wrapper .single_extension .desc {
        padding-right: 10px;
    }

    .erp_pro_addons_wrapper .single_extension .desc h4{
        letter-spacing: 0.15px;
        font-weight: 700;
        margin: 0;
    }

    .erp_pro_addons_wrapper .single_extension .desc h4 a{
        text-decoration: none;
        font-size: 16px;
        color: #2C3847;
        transition: .3s linear 0s;

    }

    .erp_pro_addons_wrapper .single_extension .desc h4 a:hover{
        color: #0073aa;
    }

    .erp_pro_addons_wrapper .single_extension .desc p{
        font-size: 13px;
        color: #758598;
        letter-spacing: 0.12px;
        line-height: 19.2px;
        font-weight: 400;
        margin-bottom: 0;
    }

    /*=======================
    End Extension Stle
    =======================*/

    /*=======================
    Tab Stle
    =======================*/
    .erp_pro_addons_wrapper .filter_tab_item .button_group{
        text-align: center;
        margin-bottom: 29px;
    }
    .erp_pro_addons_wrapper .filter_tab_item .button_group li{
        list-style: none;
        display: inline-block;
    }
    .erp_pro_addons_wrapper .filter_tab_item .button_group li a{
        font-size: 12px;
        color: #525252;
        letter-spacing: 0.11px;
        background: #FFFFFF;
        border: 1px solid #E2E2E2;
        border-radius: 3px;
        text-decoration: none;
        padding: 6px 15px;
        display: inline-block;
        margin-right: 7px;
        text-transform: uppercase;
        transition: .4s linear 0s
    }

    .erp_pro_addons_wrapper .filter_tab_item .button_group li a:hover{
        background: #1A9ED4;
        color: #ffffff;
    }

    .erp_pro_addons_wrapper .filter_tab_item .button_group li a.active{
        background: #1A9ED4;
        color: #ffffff;
    }
    /*=======================
    End Tab Stle
    =======================*/

    .erp_pro_addons_wrapper .banner_section {
        opacity: 0.75;
        background-image: linear-gradient(180deg, #0396FF 0%, #ABDCFF 100%);
        border-radius: 5px;
        display: flex;
        align-items: center;
        height: 364px;
        padding: 0 49px;
    }

    .erp_pro_addons_wrapper .banner_section .image-item {
        margin-right: 35px;
    }

    .erp_pro_addons_wrapper .banner_section img {
        margin-top: 30px;
    }

    .erp_pro_addons_wrapper .banner_section .button-wrap .btn {
        padding: 13px 28px;
        display: inline;
    }


    .erp_pro_addons_wrapper .banner_section  h1{
        font-size: 27.5px;
        color: #FFFFFF;
        letter-spacing: 0.25px;
        line-height: 35.4px;
        font-weight: 900;
        margin-bottom: 20px;
    }

    .erp_pro_addons_wrapper .btn {
        border-radius: 3.15px;
        font-weight: 700;
        font-size: 12px;
        color: #FFFFFF;
        letter-spacing: 0.1px;
        background: #24C030;
        display: inline-block;
        text-decoration: none;
        padding: 10px 28px;
        transition: .3s linear 0s;
    }

    .erp_pro_addons_wrapper .get-started-btn {
        margin-right: 15px;
        box-shadow: 0 12px 31px 0 rgba(7,157,128,0.42);
    }

    .erp_pro_addons_wrapper .get-started-btn img {
        position: relative;
        top: 2px;
        left: 4px;
        transition: .3s linear 0s;
    }

    .erp_pro_addons_wrapper .button-wrap .btn:hover {
        background: #15af21;
        color: #ffffff;
    }

    .erp_pro_addons_wrapper .get-started-btn:hover img {
        left: 7px;
    }

    .erp_pro_addons_wrapper .try-demo-btn {
        background: #FFFFFF;
        box-shadow: 0 2px 4px 0 rgba(0,0,0,0.07);
        color: #334E68;
        text-decoration: none;
        padding: 10px 18px;
    }

    .erp_pro_addons_wrapper .pro-btn{
        background: #8F5CDD;
        box-shadow: 0 2px 4px 0 rgba(0,0,0,0.07);
        border-radius: 12.6px;
        font-size: 9.08px;
        color: #FFFFFF;
        letter-spacing: 0.08px;
        text-align: center;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-weight: 800;
        padding: 2px 8px;
        margin-bottom: 4px;
    }

    /*===============
    Why erp pro style
    ===============*/
    .erp_pro_addons_wrapper .why__erp__pro_section {
        padding: 50px 0;
    }
    .erp_pro_addons_wrapper .section_head {
        margin-bottom: 56px;
    }
    .erp_pro_addons_wrapper .section_head h2 {
        font-weight: 700;
        font-size: 34px;
        color: #000000;
        letter-spacing: 0.31px;
        text-align: center;
        margin-bottom: 26px;
    }
    .erp_pro_addons_wrapper .section_head p{
        font-size: 13px;
        color: #334E68;
        letter-spacing: 0.12px;
        text-align: center;
        line-height: 24px;
        font-weight: 400;
    }
    .erp_pro_addons_wrapper .section_head h2 span{
        color: #1888F5;
    }

    .erp_pro_addons_wrapper .why__erppro_wrap {
        display: flex;
        flex-flow: row wrap;
        justify-content: space-between;
    }

    .erp_pro_addons_wrapper .why__erppro_wrap .box_item {
        flex-basis: 433px;
        max-width: 433px;
        margin-bottom: 14px;


    }

    .erp_pro_addons_wrapper .why__erppro_wrap .box_item .image {
        height: 148px;
    }

    .erp_pro_addons_wrapper .why__erppro_wrap .box_item h3 {
        margin-bottom: 20px;

    }


    /*=======================
    Powerfull extension stle
    =======================*/
    .perful_extension_wrap h4{
        font-size: 18px;
        color: #08426E;
        letter-spacing: 0.16px;
        text-align: center;
        font-weight: 700;
        margin-bottom: 40px;
    }

    .erp_pro_addons_wrapper .single_extension .desc h4 {
        text-align: left;
    }

    .perful_extension_wrap .perful_extension{
        display: flex;
        justify-content: space-between;
        flex-flow: row wrap;
        padding: 0 55px;

    }

    /*=======================
    Start Premium Extension Stle
    =======================*/
    .premium_extension_section{
        padding: 50px 0 57px;
    }

    .premium_extension_section .premium_extension{
        display: flex;
        justify-content: space-between;
        flex-flow: row wrap;
        padding: 0 55px;
    }

    .premium_extension_section .section_head{
        margin-bottom: 32px;
    }
    .premium_extension_section .section_head h2{
        margin-bottom: 36px;
    }
    /*=======================
    End Premium Extension Stle
    =======================*/


    .erp_pro_addons_wrapper .say_hello_section{
        text-align: center;
        background: #2B62C9;
        border-radius: 21.6px;
        padding: 65px 0;
        position: relative;
        z-index: 1;
    }

    .erp_pro_addons_wrapper .say_hello_section:before{
        content: "";
        position: absolute;
        background: url(<?php echo esc_url( WPERP_ASSETS . '/images/wperp-addons/say-hello-illustration.png' ); ?>);
        background-size: contain;
        background-repeat: no-repeat;
        background-position: center;
        width: 100%;
        height: 183px;
        left: 0;
        z-index: -1;
    }

    @media( max-width: 767px ) {
        .erp_pro_addons_wrapper .say_hello_section:before{
            height: 100%;
        }

    }

    .erp_pro_addons_wrapper .say_hello_section h3{
        font-size: 36px;
        color: #FFFFFF;
        letter-spacing: 0.33px;
        text-align: center;
        margin: 0;
        font-weight: 700;
        margin: 0 0 28px
    }

    .erp_pro_addons_wrapper .say_hello_section h3 span{
        color: #00F4FF;
    }

    .erp_pro_addons_wrapper .say_hello_section p{
        opacity: 0.66;
        font-size: 12.96px;
        color: #FFFFFF;
        letter-spacing: 0.12px;
        text-align: center;
        line-height: 21.6px;
        font-weight: 400;
        margin: 0 0 25px;
    }

    .erp_pro_addons_wrapper .say_hello_section a{
        background: #24C030;
        box-shadow: 0 11px 29px 0 rgba(0,0,0,0.10);
        border-radius: 3.6px;
        font-size: 12.96px;
        color: #FFFFFF;
        letter-spacing: 0.12px;
        text-decoration: none;
        font-weight: 700;
        display: inline-block;
        align-items: center;
        justify-content: center;
        line-height: 100%;
        padding: 15px 28px;
        transition: .3s linear 0s;
    }

    .erp_pro_addons_wrapper .say_hello_section a img{
        position: relative;
        top: 1px;
        left: 4px;
        transition: .3s linear 0s;
    }

    .erp_pro_addons_wrapper .say_hello_section a:hover{
        background: #15af21;
        color: #ffffff;
    }

    .erp_pro_addons_wrapper .say_hello_section a:hover img{
        left: 7px;
    }

    .exclusive_feature_section {
        padding-top: 25px;
    }

    .exclusive_feature_section .section_head {
        margin-bottom: 36px;
    }

    .exclusive_feature_section .section_head h2{
        margin-bottom: 0;
        font-size: 18px;
        font-weight: 700;
        color: #08426E
    }

</style>

<?php
$add_ons = get_transient( 'wperp_pro_addons' );

if ( false === $add_ons || empty( $add_ons ) ) {
    $help_url = 'https://www.wperp.com/wp-json/erp-pro/v1/modules';
    $response = wp_remote_get( $help_url, [ 'timeout' => 15 ] );

    if ( is_wp_error( $response ) || $response['response']['code'] !== 200 ) {
        $add_ons = [];
    }
    else {
        $add_ons  = (array) json_decode( wp_remote_retrieve_body( $response ) );
    }

    if ( ! empty( $add_ons ) ) {
        //sort using title
        usort( $add_ons, function ( $a, $b ) {
            return strcmp( $a->title, $b->title );
        } );

        set_transient( 'wperp_pro_addons', $add_ons, 12 * HOUR_IN_SECONDS );
    }
}
?>

<div class="wrap">
    <h1><?php esc_html_e( 'WP ERP Pro', 'erp' ); ?> <a href="https://wperp.com/downloads/" target="_blank" class="page-title-action"><?php esc_html_e( 'View All Extensions', 'erp' ); ?></a></h1>

    <div class="erp_pro_addons_wrapper">
        <div class="banner_section">
            <div class="image-item">
                <img width="383" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/banner-image.png' ); ?>" alt="">
            </div>
            <div class="details">
                <a href="https://wperp.com/pro/" target="_blank" class="btn pro-btn"><?php echo esc_html( 'WP ERP Pro' ); ?></a>
                <h1>
                    <?php
                    printf(
                        /* translators: 1) <br> tag, 2) <br> tag */
                        esc_html__( 'The Ultimate Company %1$ s& Business Management %2$s Solution', 'erp' ),
                        '<br>',
                        '<br>'
                    );
                    ?>
                </h1>
                <div class="button-wrap">
                    <a target="_blank" href="https://wperp.com/pricing/" class="btn get-started-btn">
                        <?php esc_html_e( 'Get Started Now', 'erp' ); ?> <img width="12" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/arrow-right.png' ); ?>" alt="">
                    </a>
                    <a target="_blank" href="https://wperp.com/demo/" class="btn try-demo-btn">
                        <?php esc_html_e( 'Try Demo', 'erp' ); ?>
                    </a>
                </div>
            </div>
        </div>

        <!-- why erp pro -->
        <div class="why__erp__pro_section">
            <div class="section_head">
                <h2>
                    <?php
                    /* translators: 1) opening <span> tag, 2) closing </span> tag */
                    printf( esc_html__( 'Why WP ERP %1$sPro%2$s', 'erp' ), '<span>', '</span>' );
                    ?>
                </h2>
                <p>
                    <?php
                    /* translators: 1) <br> tag */
                    printf( esc_html__( 'Automate & manage your growing business even better %s using WP ERP Pro', 'erp' ), '<br>' );
                    ?>
                </p>
            </div>
            <div class="why__erppro_wrap">
                <div class="box_item">
                    <div class="image">
                        <img width="200" src="<?php echo esc_url( WPERP_ASSETS . '/images/wperp-addons/gain-access.png' ); ?>" alt="">
                    </div>
                    <div class="desc">
                        <h3>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Gain access to nine powerful %s extensions with a single purchase', 'erp' ), '<br>' );
                            ?>
                        </h3>
                        <p>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Use these premium extensions to %s supercharge your business', 'erp' ), '<br>' );
                            ?>
                        </p>
                    </div>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="180" src="<?php echo esc_url( WPERP_ASSETS . '/images/wperp-addons/individual-extension.png' ); ?>" alt="">
                    </div>
                    <div class="desc">
                        <h3>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Add other individual extensions %s which suit your business', 'erp' ), '<br>' );
                            ?>
                        </h3>
                        <p>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Only add those extensions which you %s need & save your money', 'erp' ), '<br>' );
                            ?>
                        </p>
                    </div>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="170" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/support-system.png' ); ?>" alt="">
                    </div>
                    <div class="desc">
                        <h3>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Priority support %s system', 'erp' ), '<br>' );
                            ?>
                        </h3>
                        <p>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Connecting you to our highly-qualified %s support team 24/7/365', 'erp' ), '<br>' );
                            ?>
                        </p>
                    </div>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="214" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/save-money.png' ); ?>" alt="">
                    </div>
                    <div class="desc">
                        <h3>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'Save money %s User-based Pricing', 'erp' ), '<br>' );
                            ?>
                        </h3>
                        <p>
                            <?php
                            /* translators: 1) <br> tag */
                            printf( esc_html__( 'You are billed for each user added to %s your user workspace.', 'erp' ), '<br>' );
                            ?>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- end why erp pro -->

        <!-- start what will get section -->
        <div class="what_wil_get_section">
            <div class="section_head">
                <h2><?php esc_html_e( 'What you will get', 'erp' ); ?></h2>
                <p>
                    <?php
                    /* translators: 1) <br> tag */
                    printf( esc_html__( 'Take your business to the next level with 9 accessible premium %s extensions  & different features', 'erp' ), '<br>' );
                    ?>
                </p>
            </div>

            <div class="perful_extension_wrap">
                <?php
                $pro_extension = array_filter( $add_ons, function ( $addon ) {
                    return $addon->is_pro ? $addon : false;
                } );
                ?>
                <h4>
                    <?php
                    /* translators: 1) number of extensions */
                    printf( esc_html__( '%s Powerful Extensions', 'erp' ), count( $pro_extension ) );
                    ?>
                </h4>
                <div class="perful_extension">
                    <!--start extension-->
                    <?php
                    foreach ( $pro_extension as $add_on ) {
                        ?>
                        <div class="single_extension">
                            <div class="image">
                                <img src="<?php echo esc_url_raw( $add_on->thumbnail_url ); ?>" alt="">
                            </div>
                            <div class="desc">
                                <h4><a target="_blank" href="<?php echo esc_url_raw( $add_on->permalink ); ?>"><?php echo esc_html( $add_on->title ); ?></a></h4>
                                <p><?php echo esc_html( $add_on->excerpt ); ?></p>
                            </div>
                        </div>
                        <?php
                    }
                    ?>
                    <!--end extension-->
                </div>
            </div>
        </div>
        <!-- end what will get section -->

        <!-- start exclusive feature section -->
        <div class="exclusive_feature_section">
            <div class="section_head">
                <h2><?php esc_html_e( 'Exclusive Features', 'erp' ); ?></h2>
            </div>
            <div class="exclusive_feature_wrap">
                <div class="box_item">
                    <div class="image">
                        <img width="110" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/hr-digest-email.png' ); ?>" alt="">
                    </div>
                    <h3>
                        <?php
                        /* translators: 1) <br> tag */
                        printf( esc_html__( 'HR Email Digest %s weekly/Monthly', 'erp' ), '<br>' );
                        ?>
                    </h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Keep up to date with the latest in %1$s HR news and trends with this %2$s exclusive feature', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="175" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/crm-life-stage.png' ); ?>" alt="">
                    </div>
                    <h3>
                        <?php
                        /* translators: 1) <br> tag */
                        printf( esc_html__( 'CRM Customizable %s Life Stages', 'erp' ), '<br>' );
                        ?>
                    </h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Try this feature now to customize %1$s Customer life stages & prioritize %2$s your work with them', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="180" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/crm-task-management.png' ); ?>" alt="">
                    </div>
                    <h3>
                        <?php
                        /* translators: 1) <br> tag */
                        printf( esc_html__( 'Task Management %s in CRM', 'erp' ), '<br>' );
                        ?>
                    </h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'The feature lets you manage %1$s tasks, collaborate among teams %2$s and be super productive', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="190" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/sale-purchase-return.png' ); ?>" alt="">
                    </div>
                    <h3><?php esc_html_e( 'Sale and Purchase Returns', 'erp' ); ?></h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Creating sales & purchase returns %1$s for your accounts is easier than ever %2$s with WP ERP Accounting', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="145" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/work-from-home.png' ); ?>" alt="">
                    </div>
                    <h3><?php esc_html_e( 'Work from Home', 'erp' ); ?></h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Digitize the process for requesting %1$s work from home privileges as well as %2$s the approval process', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="105" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/employee-resignation.png' ); ?>" alt="">
                    </div>
                    <h3><?php esc_html_e( 'Employee Resignation', 'erp' ); ?></h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Automate and simplify employee %1$s resignation process using this feature %2$s of WP ERP HR', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
                <div class="box_item">
                    <div class="image">
                        <img width="145" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/company-org-chart.png' ); ?>" alt="">
                    </div>
                    <h3><?php esc_html_e( 'Company Org Chart', 'erp' ); ?></h3>
                    <p>
                        <?php
                        /* translators: 1) <br> tag, 2) <br> tag */
                        printf( esc_html__( 'Have your organizational structure %1$s and define the flow of employees\' %2$s work with this feature', 'erp' ), '<br>', '<br>' );
                        ?>
                    </p>
                </div>
            </div>
        </div>
        <!-- end exclusive feature section -->

        <!-- start premium extension section -->
        <div class="premium_extension_section">
            <div class="section_head">
                <h2><?php esc_html_e( 'Choose other premium extensions', 'erp' ); ?></h2>
                <p><?php esc_html_e( 'Build a modern, convenient and reliable business<br>management system for your company', 'erp' ); ?></p>
            </div>
            <div class="filter_wrapper">
                <div class="filter_tab_item">
                    <ul id="filters" class="button_group">
                        <li>
                            <a href="#" class="active" data-target="all"><?php esc_html_e( 'All', 'erp' ); ?></a>
                        </li>
                        <li>
                            <a href="#" data-target="hrm"><?php esc_html_e( 'HRM', 'erp' ); ?></a>
                        </li>
                        <li>
                            <a href="#" data-target="accounting"><?php esc_html_e( 'Accounting', 'erp' ); ?></a>
                        </li>
                        <li>
                            <a href="#" data-target="crm"><?php esc_html_e( 'CRM', 'erp' ); ?></a>
                        </li>
                    </ul>
                </div>
            </div>
            <div class="premium_extension">

                <?php
                foreach ( $add_ons as $add_on ) {
                    $class = '';

                    if ( $add_on->is_pro ) {
                        continue;
                    }

                    if ( $add_on->is_hrm ) {
                        $class .= ' hrm';
                    }

                    if ( $add_on->is_crm ) {
                        $class .= ' crm';
                    }

                    if ( $add_on->is_accounting ) {
                        $class .= ' accounting';
                    } ?>
                    <!--start extension-->
                    <div class="single_extension <?php echo esc_attr( $class ); ?>">
                        <div class="image">
                            <img src="<?php echo esc_url( $add_on->thumbnail_url ); ?>" alt="">
                        </div>
                        <div class="desc">
                            <h4><a target="_blank" href="<?php echo esc_url( $add_on->permalink ); ?>"><?php echo esc_html( $add_on->title ); ?></a></h4>
                            <p><?php echo esc_html( $add_on->excerpt ); ?></p>
                        </div>
                    </div>
                    <!--end extension-->
                    <?php
                }
                ?>
            </div>
        </div>
        <!-- end premium extension section -->

        <!-- start say hello section -->
        <div class="say_hello_section">
            <div class="say_hello_inner_section">
                <h3>
                    <?php
                        /* translators: 1) opening <span> tag, 2) closing </span> tag */
                        printf( esc_html__( 'Say Hello to WP ERP %1$sPro%2$s', 'erp' ), '<span>', '</span>' );
                    ?>
                </h3>
                <p>
                    <?php
                    /* translators: 1) <br> tag */
                    printf( esc_html__( 'And goodbye to papers, spreadsheets, wasted time, %s uncertainty, frustration - run business smoothly.', 'erp' ), '<br>' );
                    ?>
                </p>
                <a target="_blank" href="https://wperp.com/pro/"><?php esc_html_e( 'Get Started Now', 'erp' ); ?> <img width="12" src="<?php echo esc_url_raw( WPERP_ASSETS . '/images/wperp-addons/arrow-right.png' ); ?>" alt=""></a>
            </div>
        </div>
        <!-- end say hello section -->
    </div>
</div>

<script>
    ; (function ($) {
        // category filter handler
        $( "#filters li a" ).click( function(e) {
            if( $( this ).attr( 'data-target' ) ) {
                e.preventDefault();
                $( '#filters li a' ).removeClass( 'active' );
                $( this ).addClass( 'active' );

                var clickedItem = $( this ).data( 'target' );
                var singleDownloadItem = $( '.premium_extension .single_extension' );
                if ( clickedItem === 'all' ) {
                    singleDownloadItem.show();
                } else {
                    singleDownloadItem.each( function(){
                        if( $( this ).hasClass( clickedItem ) ) {
                            $( this ).show();
                        } else {
                            $( this ).hide();
                        }
                    } )
                }
            }
        } );
    })(jQuery);


</script>
